// Log.h: interface for the CLog class.
//
//////////////////////////////////////////////////////////////////////
#pragma once

#include "File.h"


class CLog {

public:

	/**
	 * Base class for log manipulators
	 */

	class Manipulator {
	public:
		bool	m_fUse;
		Manipulator() : m_fUse(true) {}
		Manipulator(bool fUse) : m_fUse(fUse) {}
		Manipulator(const Manipulator& manip) : m_fUse(manip.m_fUse) {}
		virtual ~Manipulator() {}
	};

	class StdOut : public Manipulator {
	public:
		StdOut() {}
		StdOut(bool fUse) : Manipulator(fUse) {}
		virtual ~StdOut() {}
	};

	class StdErr : public Manipulator {
	public:
		StdErr() {}
		StdErr(bool fUse) : Manipulator(fUse) {}
		virtual ~StdErr() {}
	};

	class FileOut : public Manipulator {
	public:
		FileOut() {}
		FileOut(bool fUse) : Manipulator(fUse) {}
		virtual ~FileOut() {}
	};

	class FlushStd : public Manipulator {
	public:
		FlushStd() {}
	};


	/**
	 * Special manipulator that is used to keep current state on stack for future restore
	 * by means of Pop manipulator
	 */

	class Push : public Manipulator {
	public:
		const Manipulator*	m_pManip;
		Push(const Manipulator* pManip) : m_pManip(pManip) {}
	};


	/**
	 * Special manipulator that is used to reset all states and set one.
	 * Previous states are kept on stack.
	 */

	class SetSingle : public Manipulator {
	public:
		const Manipulator*	m_pManip;
		SetSingle(const Manipulator* pManip) : m_pManip(pManip) {}
	};


	/**
	 * Special manipulator that is used to set all states and reset one.
	 * Previous states are kept on stack.
	 */

	class ResetSingle : public Manipulator {
	public:
		const Manipulator*	m_pManip;
		ResetSingle(const Manipulator* pManip) : m_pManip(pManip) {}
	};


	/**
	 * Special manipulator that is used to restore state from states stack
	 */

	class Pop : public Manipulator {
	public:
		int	m_nDeep;	// deep level: how many states will be restored from stack
		Pop() : m_nDeep(1) {}
		Pop(int nDeep) : m_nDeep(nDeep) {}
	};


	CLog();
	virtual ~CLog();

	bool Open(LPCTSTR szLogFileName);

	CLog& operator <<(const tstring& s);
	CLog& operator <<(LPCTSTR szData);
	CLog& operator <<(int iValue);
	CLog& operator <<(unsigned short usValue);

	CLog& operator <<(const StdOut&   manip);
	CLog& operator <<(const StdErr&   manip);
	CLog& operator <<(const FileOut&  manip);
	CLog& operator <<(const FlushStd& manip);

	CLog& operator <<(const Push& push);
	CLog& operator <<(const SetSingle& manip);
	CLog& operator <<(const ResetSingle& manip);
	CLog& operator <<(const Pop& pop);

protected:

	CFile	m_file;

	bool	m_fLogIntoStdOut;
	bool	m_fLogIntoStdErr;
	bool	m_fLogIntoFileOut;

	HANDLE	m_hStdOut;
	HANDLE	m_hStdErr;

	std::vector<bool>	m_vStates;
};
